#ifndef UNIV_H
#define UNIV_H

#include <pads.h>
#include <stdio.h>
#include <osfcn.h>
#include <libc.h>
#include <time.h>

#include "lib.h"


enum Op{
	O_DEREF		= 1,
	O_REF		= 2,
	O_INDEX		= 3,
	O_DOT		= 4,
	O_ARROW		= 5,
	O_PLUS		= 6,
	O_MINUS		= 7,
	O_MULT		= 8,
	O_DIV		= 9,
	O_CALL		= 10,
	O_MOD		= 11,
	O_ASSIGN	= 12,
	O_COMMA		= 13,
	O_SIZEOF	= 14,
	O_TYPEOF	= 15,
	O_QINDEX	= 16,
	O_CAST		= 17,
	O_QCAST		= 18,
	O_EQ		= 19,
	O_NE		= 20,
	O_LT		= 21,
	O_GT		= 22,
	O_LE		= 23,
	O_GE		= 24,
	O_ENV		= 25,
	O_LOGAND	= 26,
	O_LOGOR		= 27,
	O_LOGNOT	= 28,
	O_BITAND	= 29,
	O_BITOR		= 30,
	O_1SCOMP	= 31,
	O_BITXOR	= 32,
	O_FABS		= 33,
	O_QSTRUCT	= 34,
	O_QENUM		= 35,
	O_RANGE		= 36,
	O_SPECIAL	= 40,
	O_LSHIFT	= 41,
	O_RSHIFT	= 42,
};

enum EDisc{
	E_UNARY		= 1,
	E_BINARY	= 2,
	E_LCONST	= 3,
	E_DCONST	= 4,
	E_ID		= 5,
	E_SYMNODE	= 6,
};

enum Behavs {
	BREAKED		= 1,
	ERRORED		= 0,
	HALTED		= 2,
	ACTIVE		= 3,
	PENDING		= 4,
	STMT_STEPPED	= 5,
	INST_STEPPED	= 6,
};

class Asm;
class Block;
class Bls;
class Bpts;
class BptReq;
class CallStk;
class Context;
class Core;
class CoreContext;
class Cslfd;
class DType;
class Expr;
class Frame;
class Func;
class Globals;
class SunosTShare;
class SunosType;
class SunosSymTab;
class Index;
class Journal;
class Master;
class Memory;
class Pad;
class Phrase;
class Process;
class Remote;
class SigBit;
class SigMask;
class Source;
class SrcDir;
class Stmt;
class SymTab;
class Symbol;
class Trap;
class UType;
class Var;

inline int eqstr(char *a, char *b)
{
	return !a ? !b : b && *a==*b && !strcmp(a+1,b+1);
}


class Cslfd {
	 void	init(long l, double d);
public:
	 char	*flterr;
	 double	dbl;
	 float	flt;
	 long	lng;
	 short	sht;
	 char	chr;
unsigned char	uch();
unsigned short	ush();
	 char	*floaterror();
	 	Cslfd(long);
	 	Cslfd(double);
		Cslfd(int);
		Cslfd();
};

enum UDisc {
	U_ERROR		= 0,

	U_FUNC		= 1,
	U_GLB		= 2,
	U_STA		= 3,
	U_STMT		= 4,
	U_UTYPE		= 5,
#				define TOSYM 0x7	/* 2^n-1 */
	U_ARG		= 10,
	U_AUT		= 11,
	U_BLOCK		= 12,
	U_FST		= 13,
	U_MOT		= 14,
	U_SOURCE	= 15,

	U_ASM		= 20,
	U_AUDIT		= 21,
	U_BLKVARS	= 22,
	U_BPTS		= 23,
	U_CELL		= 24,
	U_CORE		= 25,
	U_DTYPE		= 26,
	U_EXPR		= 27,
	U_MASTER	= 28,
	U_GLOBALS	= 29,
	U_INSTR		= 30,
	U_MEMORY	= 32,
	U_PHRASE	= 33,
	U_PROCESS	= 34,
	U_REG		= 35,
	U_SRCTEXT	= 39,
	U_SYMTAB	= 41,
	U_TRAP		= 42,
	U_TYPMEMS	= 43,
	U_WD		= 44,
	U_SIGMASK	= 45,
	U_HELP		= 46,
	U_SRCDIR	= 47,
	U_CONTEXT	= 48,
	U_HOSTMASTER	= 49,
	U_SIGBIT	= 50,
	U_BPTREQ	= 51,
	U_JOURNAL	= 52,
	U_FRAME		= 53,
};

#define PUBLIC(c,d)\
	int	disc();\
public:\
	int	ok()	{ return this && disc() == d; }

#define SVP	1	/* != 0 */
#endif
